CREATE TABLE #Rs (CD_EMP INT, CD_FILIAL INT, DT_FECHA_CX DATETIME, VLR_NCC_CHQ  MONEY, VLR_NCC_VALE_COMPRA MONEY )
INSERT INTO #Rs
SELECT    
    PDV_VD_DEV_NCC.CD_EMP,
    PDV_VD_DEV_NCC.CD_FILIAL,
    PDV_VD_DEV_NCC.DT_FECHA_CX,      
    SUM(CASE WHEN PDV_VD.VLR_CHQS > 0 THEN
	   PDV_VD_DEV_NCC.VLR_NCC
    ELSE
	   0
    END) As VLR_NCC_VD_CANCELADA_CHEQUE,
    SUM(PDV_VD.VLR_TICKETS) AS VLR_NCC_CANCELADA_VALE_COMPRA
FROM 
PDV_VD_DEV_NCC 
LEFT OUTER JOIN
(
SELECT
DISTINCT
PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP.CD_EMP,
PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL,
PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP.CD_VD,
PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP.CD_CTR_NCC
FROM
PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP
) PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP ON
PDV_VD_DEV_NCC.CD_CTR_NCC = PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP.CD_CTR_NCC
INNER JOIN PDV_VD
ON PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP.CD_EMP    =PDV_VD.CD_EMP
AND PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL =PDV_VD.CD_FILIAL
AND PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP.CD_VD     = PDV_VD.CD_VD
WHERE
PDV_VD_DEV_NCC.CD_EMP = 1
AND PDV_VD_DEV_NCC.STS_NCC IN(2,3)
AND (PDV_VD.VLR_DUP + PDV_VD.VLR_CONV + PDV_VD.VLR_CARTAO + PDV_VD.VLR_CHQS + PDV_VD.VLR_CONV_PBM ) > 0 
GROUP BY
    PDV_VD_DEV_NCC.CD_EMP,
    PDV_VD_DEV_NCC.CD_FILIAL,
    PDV_VD_DEV_NCC.DT_FECHA_CX

UPDATE
    PDV_VD_FECHA_MOV
SET
   VLR_NCC_CANCELADA_CHQ=S.VLR_NCC_CHQ,
   VLR_NCC_CANCELADA_VALE_COMPRA=S.VLR_NCC_VALE_COMPRA
FROM
    PDV_VD_FECHA_MOV INNER JOIN #Rs S ON
    PDV_VD_FECHA_MOV.CD_EMP = S.CD_EMP AND
    PDV_VD_FECHA_MOV.CD_FILIAL = S.CD_FILIAL AND
    PDV_VD_FECHA_MOV.DT_MOV = S.DT_FECHA_CX

DROP TABLE #Rs